; (*| 22:06 15/11/1990 *)
TITLE	FONT2
PAGE	60,78
;
LF	EQU 0AH
CR	EQU 0DH
WORD_OUTS_OK	EQU	1
;
CHARS_PER_FONT		EQU 256
MAX_BYTES_PER_CHAR	EQU	32
;
DOSF_CONOUT	EQU  2		; Console output
DOSF_OUTSTR	EQU 09H		; Output string
DOSF_OPENH	EQU 3DH
DOSF_CLOSEH	EQU 3EH
DOSF_READH	EQU 3FH
DOSF_MOVFPTR	EQU 42H
DOSF_TERMPROC	EQU 4CH
;
DOSI_VIDEO	EQU 10H 	; Video interrupt
DOSI_TERM	EQU 20H 	; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
;
;  EGA Graphics Controller Registers

BASE_ONE	EQU 3C0H	; Normal EGA base address

EGA_MISC	EQU 2
EGA_SEQ_INDEX	EQU 4
EGA_SEQ_DATA	EQU 5
EGA_SEQ_WPM	EQU 2		; index of write plane
EGA_SEQ_MODE	EQU 4		; index of memory mode

EGA_GCR_INDEX	EQU 0EH
EGA_GCR_DATA	EQU 0FH
EGA_GCR_ENABLE	EQU 1		; index of enable
EGA_GCR_RMS	EQU 4		; index of read plane

EGA_INP_STATUS	EQU 1AH

EGA_SEG_BASE	EQU 0A000H

Out_Word	MACRO
IF WORD_OUTS_OK
	OUT	DX,AX
ELSE
	OUT	DX,AL
	INC	DX
	XCHG	AH,AL
	OUT	DX,AL
	DEC	DX
	XCHG	AH,AL
ENDIF
	ENDM

CODE	SEGMENT BYTE PUBLIC

ASSUME	CS:CODE,DS:CODE

	ORG	100H
START:
	CLD
	MOV	DX,OFFSET TITMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	CALL	PROCESS_COMMAND_STRING
	MOV	SI,WORD PTR CS:COMMAND_PTR
	MOV	CX,WORD PTR CS:COMMAND_PTR+2    ;length
	CMP	CX,0
	JZ	NOT_HELP
;	JZ	NO_COMMAND
	CMP	BYTE PTR [SI],'?'
	JNZ	NOT_HELP
NO_COMMAND:
	MOV	DX,OFFSET HLPMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	RET				 ; exit program to DOS

NOT_HELP:
	MOV	AX,'/c'		     ;clear screen option
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_C_OPTION	    ;option not found
	MOV	BYTE PTR CLEAR_FLAG,0FFH
NOT_C_OPTION:
	MOV	AX,'/v'		     ;verify option
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_V_OPTION	    ;option not found
	MOV	BYTE PTR VERIFY_FLAG,0FFH
NOT_V_OPTION:
	MOV	AX,'/m'		     ;multiple option
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_M_OPTION	    ;option not found
	MOV	BYTE PTR MULTIPLE_FLAG,0FFH
NOT_M_OPTION:
	MOV	AX,'/b' 		;set block number
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_B_OPTION	    ;option not found
	CMP	CX,3
	JNE	NOT_B_OPTION
	ADD	SI,2
	SUB	CX,2
	CALL	ASCII_TO_BIN
	CMP	AL,3
	JA	NOT_B_OPTION
	MOV	CX,4
	SUB	CL,AL
	MOV	WORD PTR MAX_COMMAND_NUM,CX
	MOV	CL,2
	SHL	AL,CL			;03h -> 0Ch 
	MOV	BYTE PTR BLOCK_NUM,AL
NOT_B_OPTION:
	MOV	AX,'/i'		     ;initialise mode option
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_I_OPTION	    ;option not found
	CMP	CX,4
	JNE	NOT_I_OPTION
	ADD	SI,2
	SUB	CX,2
	CALL	ASCII_TO_BIN
	MOV	BYTE PTR EGA_MODE,AL
NOT_I_OPTION:
	MOV	CX,WORD PTR COMMAND_NUM
	CALL	NOT_OPTION_COMMAND      ;check number of / commands ??
	JB	NO_FONT_FILE	    ;skip if no plain command
	PUSH	CX
	MOV	BYTE PTR FONT_FLAG,0FFH
	MOV	CX,4000H
	MOV	DI,OFFSET BUFFER
	SUB	AX,AX
	REP	STOSW			;fill 8000h bytes of buffer with 0
	POP	CX
	CALL	OPEN_FONT_FILE
	CMP	BYTE PTR MULTIPLE_FLAG,0
	JZ	NOT_MULTIPLE
MULTI_LOOP:
	ADD	WORD PTR BUFFER_PTR,4000H
	INC	WORD PTR COMMAND_NUM
	MOV	CX,WORD PTR COMMAND_NUM
	CMP	CX,WORD PTR MAX_COMMAND_NUM
	JA	NO_FONT_FILE
	CALL	NOT_OPTION_COMMAND      ;check number of / commands ??
	JB	NO_FONT_FILE	    ;skip if no plain command
	CALL	OPEN_FONT_FILE
	ADD	WORD PTR FONT_SIZE,4000H
	JMP	MULTI_LOOP
NOT_MULTIPLE:
NO_FONT_FILE:
	MOV	CS:WORD PTR EGABASE,BASE_ONE
	CALL	SET_MODE
	MOV	CX,WORD PTR FONT_SIZE
	CMP	BYTE PTR FONT_FLAG,0
	JNE	COPY_TO_FIRST
	MOV	SI,0
	MOV	DI,OFFSET BUFFER
	CALL	COPY_FROM_EGA_DATA
	JMP	SHORT DONE_FIRST

COPY_TO_FIRST:
	MOV	SI,OFFSET BUFFER
	MOV	DI,0
	CALL	COPY_TO_EGA_DATA
DONE_FIRST:
	CALL	RESET_MODE
	MOV	AX,0E06H		; index 6 misc data, enable at B800h
	Out_Word
	CMP	BYTE PTR CLEAR_FLAG,0
	JE	NO_BLANK
	MOV	AX,0B800H
	CALL	CLR_SCREEN
NO_BLANK:
	INT	DOSI_TERM

CLR_SCREEN	PROC
	PUSH	ES
	MOV	ES,AX
	MOV	DI,0
	MOV	CX,8000H
	MOV	AX,0720H
	REP	STOSW
	POP	ES
	RET
CLR_SCREEN	ENDP

SET_MODE	PROC
	MOV	DX,CS:WORD PTR EGABASE
	ADD	DX,EGA_SEQ_INDEX
	MOV	AX,0100H		; index 0 data 1 reset
	Out_Word
	MOV	AX,0402H		; index 2 data 4 wpm
	Out_Word
	MOV	AX,0704H		; index 4 data 7 mem mode
	Out_Word
	MOV	AX,0300H		; index 0 data 1 run
	Out_Word
	MOV	DX,CS:WORD PTR EGABASE
	ADD	DX,EGA_GCR_INDEX
	MOV	AX,0000H		; index 0 mode data 0
	Out_Word
	MOV	AX,0001H		; index 1 mode data 0
	Out_Word
	MOV	AX,0002H		; index 2 mode data 0
	Out_Word
	MOV	AX,0003H		; index 3 mode data 0
	Out_Word
	MOV	AX,0204H		; index 4 mode data 2
	Out_Word
	MOV	AX,0005H		; index 5 mode data 0
	Out_Word
	MOV	AX,0406H		; index 6 misc data 7
	Out_Word
	MOV	AX,0FF08H		; index 8 mode data 0FFh
	Out_Word
	RET
SET_MODE	ENDP

; exit with DX=GCR

RESET_MODE	PROC
	MOV	DX,CS:WORD PTR EGABASE
	ADD	DX,EGA_SEQ_INDEX
	MOV	AX,0100H		; index 0 data 1 reset
	Out_Word
	MOV	AX,0302H		; index 2 data 3 wpm
	Out_Word
	MOV	AX,0304H		; index 4 data 3 mem mode
	Out_Word
	MOV	AX,0300H		; index 0 data 1 run
	Out_Word
	MOV	DX,CS:WORD PTR EGABASE
	ADD	DX,EGA_GCR_INDEX
	MOV	AX,0004H		; index 4 mode data 0
	Out_Word
	MOV	AX,1005H		; index 5 mode data
	Out_Word
	RET				; return with DX = gcr_index
RESET_MODE	ENDP

;
; On entry, CX=count, SI=source start offset, DI=destination offset
;
COPY_FROM_EGA_DATA   PROC
	PUSH	CX
	PUSH	DS
	PUSH	ES

	PUSH	DS
	POP	ES			; ensure ES=DS
	MOV	AX,EGA_SEG_BASE
	ADD	AH,CS:BYTE PTR BLOCK_NUM
	MOV	DS,AX

;	assume	ds:ega_seg_base

	CLI
	REP	MOVSB			; copy from DS:SI to ES:DI
	STI

	POP	ES
	POP	DS

	ASSUME	DS:CODE

	POP	CX
	RET
COPY_FROM_EGA_DATA   ENDP

;
; On entry, CX=count, SI=source start offset, DI=destination offset
;
COPY_TO_EGA_DATA   PROC
	PUSH	CX
	PUSH	ES

	MOV	AX,EGA_SEG_BASE
	ADD	AH,CS:BYTE PTR BLOCK_NUM
	MOV	ES,AX

;	assume	es:ega_seg_base

	CLI
	REP	MOVSB			; copy from DS:SI to ES:DI
	STI

	POP	ES

	ASSUME	ES:CODE

	POP	CX
	RET
COPY_TO_EGA_DATA   ENDP

;process command string into individual commands or options

PROCESS_COMMAND_STRING	PROC
	MOV	SI,WORD PTR COMMAND_OFFSET       ;080H, command string
	MOV	WORD PTR COMMAND_LENGTH,0
	MOV	CL,[SI]
	MOV	CH,0		     ;CX= length(command string)
	INC	SI
	MOV	DI,OFFSET COMMAND_PTR
	CMP	CX,0
	JZ	P_C_S_DONE		    ;ret if zero length
P_C_S_NEXT_CMD:
	MOV	AL,' '
P_C_S_SPACE_LOOP:
	CMP	[SI],AL
	JNZ	P_C_S_NOT_SPACE
	INC	SI
	LOOP	P_C_S_SPACE_LOOP
	JMP	SHORT P_C_S_DONE	     ; ret

P_C_S_NOT_SPACE:
	INC	WORD PTR COMMAND_LENGTH
	MOV	[DI],SI		     ;save ptr
P_C_S_N_S_LOOP:
	CMP	[SI],AL
	JZ	P_C_S_NEXT_SPACE
	INC	SI
	LOOP	P_C_S_N_S_LOOP
P_C_S_NEXT_SPACE:
	MOV	AX,SI
	SUB	AX,[DI]
	MOV	[DI+2],AX		     ;save length in next word
	ADD	DI,4		     ;next word pair
	MOV	BYTE PTR [SI],0	     ;mark end of string
	INC	SI
	DEC	CX
	JLE	P_C_S_DONE
	CMP	WORD PTR COMMAND_LENGTH,8
	JL	P_C_S_NEXT_CMD
P_C_S_DONE:
	RET
PROCESS_COMMAND_STRING	ENDP

;search for options
;DX=option

SEARCH_FOR_OPTIONS	PROC
	MOV	DI,OFFSET COMMAND_PTR
	MOV	DX,AX
S_F_O_LOOP:
	CMP	BYTE PTR [DI+2],0	     ;command length
	JZ	S_F_O_NO_MORE
	MOV	SI,[DI]
	MOV	CX,[DI+2]
	MOV	AX,[SI]
	CMP	AL,'/'
	JNZ	S_F_O_NEXT_PAIR
	OR	AH,20H		    ;to lower
	CMP	AH,DL
	JZ	S_F_O_FOUND
S_F_O_NEXT_PAIR:
	ADD	DI,4		     ;next command pair
	JMP	SHORT	S_F_O_LOOP

S_F_O_FOUND:
	CLC
	RET

S_F_O_NO_MORE:
	STC
	RET
SEARCH_FOR_OPTIONS	ENDP

;get not option command n
;CL=command number

NOT_OPTION_COMMAND	PROC
	MOV	CH,CL
	MOV	CL,1
	MOV	DI,OFFSET COMMAND_PTR
N_O_C_LOOP:
	MOV	SI,[DI]
	OR	SI,SI
	JZ	N_O_C_NO_MORE
	CMP	BYTE PTR [SI],'/'
	JZ	N_O_C_NEXT_PAIR
	CMP	CH,CL
	JZ	N_O_C_OK
	INC	CL
N_O_C_NEXT_PAIR:
	ADD	DI,4
	JMP	SHORT	N_O_C_LOOP

N_O_C_NO_MORE:
	STC
	RET

N_O_C_OK:
	MOV	CX,[DI+2]		     ;CX=length
	CLC
	RET				 ;SI=command ptr
NOT_OPTION_COMMAND	ENDP

;write string at SI, nul terminated

WRITE_STRING_SI PROC
	MOV	AH,DOSF_CONOUT
W_S_SI_LOOP:
	MOV	DL,[SI]
	OR	DL,DL
	JZ	W_S_SI_DONE
	INT	DOSI_FUNC
	INC	SI
	JMP	SHORT	W_S_SI_LOOP

W_S_SI_DONE:
	RET
WRITE_STRING_SI ENDP

;open font file, name SI, length CX

OPEN_FONT_FILE	PROC
;	MOV	AX,WORD PTR NEXT_BUFFER_PTR
;	MOV	BX,WORD PTR MAX_FILE_SIZE
;	ADD	WORD PTR NEXT_BUFFER_PTR,BX
;	MOV	WORD PTR OLD_BUFFER_PTR,AX
	MOV	WORD PTR FILE_NAME_PTR,SI
	MOV	WORD PTR FILE_NAME_LENGTH,CX
	MOV	DX,SI
	MOV	AX,DOSF_OPENH*256
	INT	DOSI_FUNC
	JNB	OPEN_OK
	MOV	DX,OFFSET L031B	     ;' Cannot open input file: $'
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	SI,WORD PTR FILE_NAME_PTR
	CALL	WRITE_STRING_SI
	MOV	DX,OFFSET CRLFMSG	       ;CR,LF
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 16
	INT	DOSI_FUNC

OPEN_OK:
	MOV	WORD PTR HANDLE_NUMBER,AX
	MOV	BX,AX
	MOV	AX,DOSF_MOVFPTR*256 + 2
	MOV	CX,0
	MOV	DX,0
	INT	DOSI_FUNC
	JNB	PTR_OK
PTR_DOS_ERROR:
	JMP	DOS_ERROR

PTR_OK:	OR	DX,DX
	JNZ	SIZE_ERROR
	MOV	WORD PTR FILE_LENGTH,AX
	MOV	BX,WORD PTR HANDLE_NUMBER
	MOV	AX,DOSF_MOVFPTR*256
	MOV	CX,0
	MOV	DX,0
	INT	DOSI_FUNC
	JB	PTR_DOS_ERROR
	MOV	AX,WORD PTR FILE_LENGTH
	MOV	BYTE PTR BYTES_PER_CHAR,AH
	CMP	AX,WORD PTR MAX_FILE_SIZE
	JBE	SIZE_OK
SIZE_ERROR:
	MOV	DX,OFFSET L0350	     ;' File size out of range: $'
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	SI,WORD PTR FILE_NAME_PTR
	CALL	WRITE_STRING_SI
	MOV	DX,OFFSET CRLFMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 17
	INT	DOSI_FUNC

SIZE_OK:
	MOV	CX,CHARS_PER_FONT	;number of byte patterns to be read
	MOV	BX,WORD PTR HANDLE_NUMBER
;	MOV	DX,OFFSET BUFFER
	MOV	DX,WORD PTR BUFFER_PTR
READ_NEXT:
	PUSH	CX
	SUB	CH,CH
	MOV	CL,BYTE PTR BYTES_PER_CHAR
	MOV	AH,DOSF_READH	     ;read font file
	INT	DOSI_FUNC
	JNB	READ_OK
	MOV	DX,OFFSET L0335	     ;' Error reading font file: $'
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	SI,WORD PTR FILE_NAME_PTR
	CALL	WRITE_STRING_SI
	MOV	DX,OFFSET CRLFMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 18
	INT	DOSI_FUNC

READ_OK:
	ADD	DX,MAX_BYTES_PER_CHAR	;position for next font char def
	POP	CX
	LOOP	READ_NEXT
	MOV	SI,WORD PTR FILE_NAME_PTR
	MOV	CX,WORD PTR FILE_NAME_LENGTH
	MOV	AL,'\'
	ADD	SI,CX
STRIP_LOOP:
	CMP	AL,[SI-1]
	JZ	STRIP_DONE
	DEC	SI
	LOOP	STRIP_LOOP
STRIP_DONE:
	MOV	WORD PTR FILE_NAME_PTR,SI	     ;file name, less path
	RET
OPEN_FONT_FILE	ENDP

DOS_ERROR	PROC
	MOV	DX,OFFSET L036A	     ;' DOS Error $'
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 7
	INT	DOSI_FUNC
DOS_ERROR	ENDP

;source in [SI], count in CX, result in AX

ASCII_TO_BIN	PROC
	SUB	BX,BX
A_T_B_LOOP:
	SHL	BX,1
	SHL	BX,1
	SHL	BX,1
	SHL	BX,1
	LODSB
	SUB	AL,'0'
	CMP	AL,9
	JBE	A_T_B_OK
	SUB	AL,7
	AND	AL,0FH
A_T_B_OK:
	ADD	BL,AL
	LOOP	A_T_B_LOOP
	MOV	AX,BX
	RET
ASCII_TO_BIN	ENDP

TITMSG		DB	'EGA Font Copy Program by B Whitnall, V2.0a',CR,LF,'$'
HLPMSG		DB	'USAGE :    FONT2 [font] [/Bn][/C][/Inn]',CR,LF
		DB	'  font - name of ega font file',CR,LF
		DB	'  /B block n',CR,LF
		DB	'  /C clear screen',CR,LF
		DB	'  /M multiple fonts',CR,LF
		DB	'  /V verify',CR,LF
		DB	'  /I use nn as initialisation mode'
CRLFMSG		DB	CR,LF,'$'
L031B	DB	' Cannot open input file: $'
L0335	DB	' Error reading font file: $'
L0350	DB	' File size out of range: $'
L036A	DB	' DOS Error $'
CLEAR_FLAG	DB	0
FONT_FLAG	DB	0
VERIFY_FLAG	DB	0
MULTIPLE_FLAG	DB	0
BLOCK_NUM	DB	0
EGABASE 	DW	?
EGA_MODE	DB	0A7H
COMMAND_LENGTH	DW	0
COMMAND_OFFSET	DW	0080H
COMMAND_PTR	DW	16 DUP(0)       ;8 pairs, ptr+length
FILE_NAME_PTR	DW	0
FILE_NAME_LENGTH	DW	0
HANDLE_NUMBER	DW	0
FILE_LENGTH	DW	0
BYTES_PER_CHAR	DB	0
MAX_FILE_SIZE	DW	CHARS_PER_FONT * MAX_BYTES_PER_CHAR
FONT_SIZE	DW	CHARS_PER_FONT * MAX_BYTES_PER_CHAR
BUFFER_PTR	DW	OFFSET BUFFER
COMMAND_NUM	DW	1
MAX_COMMAND_NUM DW	4

THIS_SITE	LABEL NEAR
SPAN	EQU	THIS_SITE - START

IF	SPAN MOD 256
	ORG	(THIS_SITE + 256) - (SPAN MOD 256)
ENDIF

BUFFER:

CODE	ENDS

END	START


